/***************************************************************************
 * launcher
 * Copyright (C) 2013 Blizzard Entertainment
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***************************************************************************/

#include "icon.h"

#include "utils.h"
#include "winutils.h"
#include "../res/resource.h"

#include <Shlwapi.h>
#include <wincodec.h>


_COM_SMARTPTR_TYPEDEF(IWICImagingFactory, __uuidof(IWICImagingFactory));
_COM_SMARTPTR_TYPEDEF(IWICBitmapDecoder, __uuidof(IWICBitmapDecoder));
_COM_SMARTPTR_TYPEDEF(IWICBitmapFrameDecode, __uuidof(IWICBitmapFrameDecode));
_COM_SMARTPTR_TYPEDEF(IStream, __uuidof(IStream));


void LoadIconImage(std::vector<Bit8u>& bits, Bitu& bytes_per_pixel, Bit32u& rmask, Bit32u& gmask, Bit32u& bmask)
{
    bits.clear();

    HICON icon = static_cast<HICON>(::LoadImage(::GetModuleHandle(nullptr), MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, ICON_WIDTH, ICON_HEIGHT, LR_DEFAULTCOLOR));
    REQUIRE_NONNULL(icon);
    HDC dc = ::CreateCompatibleDC(nullptr);
    REQUIRE_NONNULL(dc);
    at_scope_exit([&]{ ::DeleteDC(dc); });

    BITMAPINFO bmInfo =
    {
        {
            sizeof(BITMAPINFOHEADER),
            ICON_WIDTH, ICON_HEIGHT, 1, 24, BI_RGB
        }
    };
    VOID* pBits;
    HBITMAP bmIcon = ::CreateDIBSection(dc, &bmInfo, DIB_RGB_COLORS, &pBits, nullptr, 0);
    REQUIRE_NONNULL(bmIcon);
    at_scope_exit([&]{ ::DeleteObject(bmIcon); });

    HGDIOBJ bmOld = ::SelectObject(dc, bmIcon);
    REQUIRE_NONNULL(bmOld);
    at_scope_exit([&]{ ::SelectObject(dc, bmOld); });

    REQUIRE_TRUE(::DrawIcon(dc, 0, 0, icon));

    bytes_per_pixel = 3;
    bits.resize(bytes_per_pixel * ICON_WIDTH * ICON_HEIGHT);
    memcpy(bits.data(), pBits, bits.size());
    rmask = 0x00FF0000;
    gmask = 0x0000FF00;
    bmask = 0x000000FF;
}
